<?php
namespace Drupal\fsfpay\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Drupal\commerce_order\Entity\Order;
use Drupal\Core\Controller\ControllerBase;

class CallbackController extends ControllerBase {

  public function handle(Request $request) {
    $order_id = $request->request->get('order_id');
    $paid = $request->request->get('paid');
    $hash = $request->request->get('hash');

    $order = Order::load($order_id);
    if (!$order) {
      \Drupal::logger('fsfpay')->error('Order not found on callback.');
      return new Response('Order not found', 404);
    }

    // TODO: verify hash from FSFPAY API.

    if ($paid == 1) {
      $order->set('state', 'completed');
      $order->save();
      \Drupal::logger('fsfpay')->notice('Order @order marked as paid.', ['@order' => $order_id]);
    }

    return new Response('OK', 200);
  }
}
