<?php
namespace Drupal\fsfpay\Controller;

use Drupal\commerce_order\Entity\Order;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\RedirectResponse;

class RedirectController extends ControllerBase {

  public function createPayment($order_id) {

    $order = Order::load($order_id);

    // Build redirect URL to FSFPAY production or test environment.
    // This needs final endpoint from FSFPAY documentation.
    $redirect_url = "https://pay.fsfpay.com/payment/" . $order_id;

    return new RedirectResponse($redirect_url);
  }
}
