<?php
namespace Drupal\fsfpay\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

class FSFPayForm extends FormBase {

  public function getFormId() {
    return 'fsfpay_checkout_form';
  }

  public function buildForm(array $form, FormStateInterface $form_state) {

    $form['info'] = [
      '#markup' => '<p>You will be redirected to FSFPAY to complete your cryptocurrency payment.</p>',
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Proceed to FSFPAY'),
      '#button_type' => 'primary',
    ];

    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    $order = \Drupal::routeMatch()->getParameter('commerce_order');
    if ($order) {
      $url = Url::fromRoute('fsfpay.redirect.create', ['order_id' => $order->id()], ['absolute' => TRUE]);
      $form_state->setRedirectUrl($url);
    }
  }
}
