<?php
namespace Drupal\fsfpay\Plugin\Commerce\PaymentGateway;

use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\OnsitePaymentGatewayBase;
use Drupal\commerce_payment\Plugin\Commerce\PaymentGateway\PaymentGatewayInterface;
use Drupal\commerce_payment\PaymentResult;
use Drupal\Core\Url;

/**
 * @CommercePaymentGateway(
 *   id = "fsfpay",
 *   label = "FSFPAY",
 *   display_label = "Pay with FSFPAY",
 *   forms = {
 *     "add-payment-method" = "Drupal\fsfpay\Form\FSFPayForm",
 *   },
 * )
 */
class FSFPay extends OnsitePaymentGatewayBase implements PaymentGatewayInterface {

  public function defaultConfiguration() {
    return [
      'api_key' => '',
      'api_user' => '',
      'secret_key' => '',
      'mode' => 'test',
    ] + parent::defaultConfiguration();
  }

  public function buildConfigurationForm(array $form, \Drupal\Core\Form\FormStateInterface $form_state) {
    $form = parent::buildConfigurationForm($form, $form_state);

    $form['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => $this->configuration['api_key'],
      '#required' => TRUE,
    ];
    $form['api_user'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Username'),
      '#default_value' => $this->configuration['api_user'],
      '#required' => TRUE,
    ];
    $form['secret_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Secret Key'),
      '#default_value' => $this->configuration['secret_key'],
      '#required' => TRUE,
    ];
    return $form;
  }

  public function submitConfigurationForm(array &$form, \Drupal\Core\Form\FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $values = $form_state->getValues();
    $this->configuration['api_key'] = $values['api_key'];
    $this->configuration['api_user'] = $values['api_user'];
    $this->configuration['secret_key'] = $values['secret_key'];
  }
}
