<?php
namespace Drupal\fsfpay\Service;

use GuzzleHttp\ClientInterface;
use Psr\Log\LoggerInterface;

class FsfPayApi {

  protected $client;
  protected $logger;

  public function __construct(ClientInterface $client, LoggerInterface $logger) {
    $this->client = $client;
    $this->logger = $logger;
  }

  public function call($endpoint, $data = []) {
    try {
      $response = $this->client->post($endpoint, [
        'form_params' => $data
      ]);
      return json_decode($response->getBody()->getContents(), TRUE);
    } catch (\Exception $e) {
      $this->logger->error('FSFPAY API error: @msg', ['@msg' => $e->getMessage()]);
      return FALSE;
    }
  }
}
