# FSFPAY Flask Demo - Secure (Real Payments, Docker)

This demo shows FSFPAY integration with embedded iframe widget, callback verification, and Docker support.
**Endpoints use https://panel.fsfpay.com/api/** and demo is configured for real payments (testmode=0).

## Files
- `fsfpay.py` - client wrapper (get_cryptocurrencies + create_payment + verify callback)
- `app.py` - Flask demo app with index, callback (verified), and success endpoints
- `templates/` - index.html and iframe.html
- `Dockerfile` - build runnable container

## Quick start (docker)
1. Build:
```
docker build -t fsfpay-demo-secure .
```
2. Run (map port and set env vars):
```
docker run -e FSFPAY_USERNAME=your_user -e FSFPAY_API_KEY=your_key \
  -e FSFPAY_SECRET=your_secret -p 5000:5000 fsfpay-demo-secure
```
3. Open http://localhost:5000

## Quick start (local)
1. Install deps:
```
pip install flask requests
```
2. Set env vars:
```
export FSFPAY_USERNAME=your_user
export FSFPAY_API_KEY=your_key
export FSFPAY_SECRET=your_secret
```
3. Run:
```
python app.py
```

## Callback verification
The demo verifies callbacks by checking the `requestHash` in payload matches:
```
sha256(apiKey + apiUsername + apiSecret)
```
If verification fails, callback is rejected with 400.

## Notes
- Use HTTPS in production.
- Secure your secrets (don't hardcode).
- Adjust timeouts, logging, and error handling as needed.
