<?php
if (!defined('ABSPATH')) exit;
add_action('admin_menu', 'fsfpay_admin_menu');
function fsfpay_admin_menu() {
    add_menu_page('FSFPAY', 'FSFPAY', 'manage_options', 'fsfpay-settings', 'fsfpay_settings_page', 'dashicons-admin-generic', 56);
}
add_action('admin_init', 'fsfpay_register_settings');
function fsfpay_register_settings() { register_setting('fsfpay_options_group', FSFPAY_OPTION_KEY); }
function fsfpay_settings_page() {
    if (!current_user_can('manage_options')) return;
    $opts = get_option(FSFPAY_OPTION_KEY, array());
    if (isset($_POST['fsfpay_generate_shortcode']) && check_admin_referer('fsfpay_gen_nonce')) {
        $shortcodes = get_option('fsfpay_shortcodes', array());
        $attrs = array(
            'amount' => sanitize_text_field($_POST['amount']),
            'currency' => sanitize_text_field($_POST['currency']),
            'cryptocurrency' => sanitize_text_field($_POST['cryptocurrency']),
            'description' => sanitize_text_field($_POST['description']),
            'button_text' => sanitize_text_field($_POST['button_text']),
        );
        $id = time();
        $shortcodes[$id] = $attrs;
        update_option('fsfpay_shortcodes', $shortcodes);
        echo '<div class="notice notice-success is-dismissible"><p>Shortcode generated and saved.</p></div>';
    }
    if (isset($_POST['delete_id']) && check_admin_referer('fsfpay_delete_nonce')) {
        $delete_id = sanitize_text_field($_POST['delete_id']);
        $shortcodes = get_option('fsfpay_shortcodes', array());
        if (isset($shortcodes[$delete_id])) { unset($shortcodes[$delete_id]); update_option('fsfpay_shortcodes', $shortcodes); echo '<div class="notice notice-success is-dismissible"><p>Shortcode deleted.</p></div>'; }
    }
    ?>
    <div class="wrap">
        <h1>FSFPAY Settings & Shortcode Generator</h1>
        <form method="post" action="options.php">
            <?php settings_fields('fsfpay_options_group'); $opts = get_option(FSFPAY_OPTION_KEY); ?>
            <table class="form-table">
                <tr><th>API Key</th><td><input type="text" name="<?php echo FSFPAY_OPTION_KEY; ?>[apiKey]" value="<?php echo esc_attr($opts['apiKey'] ?? ''); ?>" class="regular-text"/></td></tr>
                <tr><th>API Username</th><td><input type="text" name="<?php echo FSFPAY_OPTION_KEY; ?>[apiUsername]" value="<?php echo esc_attr($opts['apiUsername'] ?? ''); ?>" class="regular-text"/></td></tr>
                <tr><th>API Secret</th><td><input type="password" name="<?php echo FSFPAY_OPTION_KEY; ?>[apiSecret]" value="<?php echo esc_attr($opts['apiSecret'] ?? ''); ?>" class="regular-text"/></td></tr>
                <tr><th>Default Currency</th><td><input type="text" name="<?php echo FSFPAY_OPTION_KEY; ?>[currency]" value="<?php echo esc_attr($opts['currency'] ?? 'USD'); ?>" class="regular-text"/></td></tr>
                <tr><th>Test Mode</th><td><select name="<?php echo FSFPAY_OPTION_KEY; ?>[testmode]"><option value="1" <?php selected($opts['testmode'] ?? 1,1); ?>>Test (1)</option><option value="0" <?php selected($opts['testmode'] ?? 1,0); ?>>Live (0)</option></select></td></tr>
                <tr><th>Coins (comma separated)</th><td><input type="text" name="<?php echo FSFPAY_OPTION_KEY; ?>[coins]" value="<?php echo esc_attr($opts['coins'] ?? 'BTC,DOGE,ETH,LTC,TRX'); ?>" class="regular-text"/><p class="description">Example: BTC,DOGE,ETH,LTC,TRX</p></td></tr>
                <tr><th>Callback URL</th><td><input type="text" name="<?php echo FSFPAY_OPTION_KEY; ?>[callbackUrl]" value="<?php echo esc_attr($opts['callbackUrl'] ?? home_url('/?fsfpay_callback=1')); ?>" class="regular-text"/></td></tr>
            </table>
            <?php submit_button(); ?>
        </form>
        <h2>Shortcode generator</h2>
        <form method="post">
            <?php wp_nonce_field('fsfpay_gen_nonce'); ?>
            <table class="form-table">
                <tr><th>Amount</th><td><input type="text" name="amount" required /></td></tr>
                <tr><th>Currency</th><td><input type="text" name="currency" value="<?php echo esc_attr($opts['currency'] ?? 'USD'); ?>" required /></td></tr>
                <tr><th>Cryptocurrency (optional)</th><td><input type="text" name="cryptocurrency" placeholder="BTC" /></td></tr>
                <tr><th>Description</th><td><input type="text" name="description" /></td></tr>
                <tr><th>Button Text</th><td><input type="text" name="button_text" value="Pay Now" /></td></tr>
            </table>
            <p class="submit"><input type="submit" name="fsfpay_generate_shortcode" class="button button-primary" value="Generate & Save Shortcode"></p>
        </form>
        <h2>Saved shortcodes</h2>
        <table class="widefat"><thead><tr><th>ID</th><th>Shortcode</th><th>Preview</th><th>Actions</th></tr></thead><tbody>
        <?php $stored = get_option('fsfpay_shortcodes', array()); foreach($stored as $id=>$sc){ $s='[fsfpay amount="'.esc_attr($sc['amount']).'" currency="'.esc_attr($sc['currency']).'" cryptocurrency="'.esc_attr($sc['cryptocurrency']).'" description="'.esc_attr($sc['description']).'" button_text="'.esc_attr($sc['button_text']).'"]'; ?>
            <tr><td><?php echo esc_html($id); ?></td><td><code><?php echo esc_html($s); ?></code></td><td><?php echo do_shortcode($s); ?></td><td>
            <button class="button copy-shortcode" data-shortcode="<?php echo esc_attr($s); ?>">Copy</button>
            <form method="post" style="display:inline;"><?php wp_nonce_field('fsfpay_delete_nonce'); ?><input type="hidden" name="delete_id" value="<?php echo esc_attr($id); ?>"><input type="submit" class="button" value="Delete"></form>
            </td></tr>
        <?php } ?>
        </tbody></table>
        <h2>Last callback (debug)</h2>
        <pre><?php echo esc_html(get_option('fsfpay_last_callback','No callbacks yet.')); ?></pre>
    </div>
    <script>(function(){document.addEventListener('click',function(e){if(e.target&&e.target.classList.contains('copy-shortcode')){navigator.clipboard.writeText(e.target.getAttribute('data-shortcode')).then(function(){alert('Shortcode copied');});}})})();</script>
    <?php
}
