jQuery(document).ready(function($){
    // Coin selection toggle
    $(document).on('click', '.fsfpay-coinlist .coin', function(){
        var $label = $(this);
        $label.find('input[type=radio]').prop('checked', true).trigger('change');
        $label.addClass('active').siblings().removeClass('active');
    });

    // Payment button
    $(document).on('click', '.fsfpay-submit', function(e){
        e.preventDefault();

        var container = $(this).closest('.fsfpay-card');
        var widgetContainer = container.find('.fsfpay-widget-container');
        var email = container.find('.fsfpay-email').val();
        var amount = container.find('.fsfpay-amount').val();
        var currency = container.find('.fsfpay-currency').val();
        var cryptocurrency = container.find('input[type=radio]:checked').val();
        var status = container.find('.fsfpay-status');

        // Reset status and container
        status.show().text('Creating payment session...');
        widgetContainer.empty().show();

        // AJAX call
        $.post(fsfpay_vars.ajax_url, {
            action: 'fsfpay_create_session',
            nonce: fsfpay_vars.nonce,
            email: email,
            amount: amount,
            currency: currency,
            cryptocurrency: cryptocurrency
        }, function(resp){
            console.log('FSFPAY response:', resp);

            if(resp.success){
                if(resp.data.scriptUrl){
                    // Script yükleme
                    var s = document.createElement('script');
                    s.src = resp.data.scriptUrl;
                    s.onload = function(){
                        status.html('Payment widget loaded below the form.');
                        console.log('FSFPAY script loaded successfully.');
                    };
                    s.onerror = function(){
                        status.text('Failed to load payment widget script.');
                    };
                    widgetContainer[0].appendChild(s);
                } else if(resp.data.payment_url){
                    var a = $('<a>')
                        .attr('href', resp.data.payment_url)
                        .attr('target','_blank')
                        .text('Open payment page');
                    status.html('Redirecting to payment... ').append(a);
                    window.open(resp.data.payment_url,'_blank');
                } else {
                    status.text('Payment created but no widget/payment URL returned.');
                }
            } else {
                status.text('Error: ' + (resp.data?.message || 'Unknown error'));
            }
        }, 'json')
        .fail(function(){
            status.text('Request failed. Please try again.');
        });
    });

    // Hover effect
    $(document).on('mouseenter', '.fsfpay-coinlist .coin', function(){
        $(this).addClass('hover');
    }).on('mouseleave', '.fsfpay-coinlist .coin', function(){
        $(this).removeClass('hover');
    });
});
