<?php
/*
Plugin Name: FSFPAY Payment Gateway - Shortcode
Plugin URI:  https://www.fsfpay.com
Description: FSFPAY crypto payment shortcode plugin with improved widget injection and UI.
Version:     1.1.0
Author:      Generated by FSFPAY
Text Domain: fsfpay
*/

if (!defined('ABSPATH')) exit;

define('FSFPAY_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FSFPAY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('FSFPAY_OPTION_KEY', 'fsfpay_options');

require_once FSFPAY_PLUGIN_DIR . 'admin.php';
require_once FSFPAY_PLUGIN_DIR . 'public.php';
require_once FSFPAY_PLUGIN_DIR . 'includes/fsfpay-api.php';

register_activation_hook(__FILE__, function(){
    $defaults = array(
        'apiKey' => '',
        'apiUsername' => '',
        'apiSecret' => '',
        'currency' => 'USD',
        'testmode' => 1,
        'coins' => 'BTC,DOGE,ETH,LTC,TRX',
        'callbackUrl' => home_url('/?fsfpay_callback=1'),
    );
    if (!get_option(FSFPAY_OPTION_KEY)) add_option(FSFPAY_OPTION_KEY, $defaults);
});

add_action('admin_enqueue_scripts', function(){
    wp_enqueue_style('fsfpay-admin-css', FSFPAY_PLUGIN_URL . 'assets/admin.css');
});
