<?php
if (!defined('ABSPATH')) exit;

function fsfpay_create_payment($params = array()) {
    $opts = get_option(FSFPAY_OPTION_KEY);
    $apiKey = $opts['apiKey'] ?? '';
    $apiUsername = $opts['apiUsername'] ?? '';
    $apiSecret = $opts['apiSecret'] ?? '';
    if(empty($apiKey) || empty($apiUsername) || empty($apiSecret)) {
        return array('success'=>false,'message'=>'FSFPAY credentials not configured.');
    }
    $post = array(
        'apiKey'=>$apiKey,
        'apiUsername'=>$apiUsername,
        'orderId'=>$params['orderId'] ?? 'WP'.time(),
        'email'=>$params['email'] ?? '',
        'amount'=>$params['amount'] ?? '',
        'currency'=>$params['currency'] ?? ($opts['currency'] ?? 'USD'),
        'cryptocurrency'=>$params['cryptocurrency'] ?? 'BTC',
        'testmode'=>isset($opts['testmode'])?intval($opts['testmode']):1,
        'callbackUrl'=>$opts['callbackUrl'] ?? home_url('/?fsfpay_callback=1'),
        'successRedirectUrl'=>$params['successRedirectUrl'] ?? home_url('/?fsfpay_success=1'),
        'language'=>$params['language'] ?? 'en',
    );
    $post['requestHash'] = hash('sha256', $apiKey . $apiUsername . $apiSecret);
    $args = array('body'=>$post,'headers'=>array('Content-Type'=>'application/x-www-form-urlencoded'),'timeout'=>30);
    $response = wp_remote_post('https://panel.fsfpay.com/api/payment', $args);
    if(is_wp_error($response)) return array('success'=>false,'message'=>$response->get_error_message());
    $body = wp_remote_retrieve_body($response);
    $json = json_decode($body,true);
    if(!$json) return array('success'=>false,'message'=>'Invalid response from FSFPAY: '.substr($body,0,200));
    return $json;
}

function fsfpay_get_supported_currencies() {
    $try = wp_remote_get('https://panel.fsfpay.com/api/currencies', array('timeout'=>8));
    if (!is_wp_error($try)) {
        $json = json_decode(wp_remote_retrieve_body($try), true);
        if ($json && isset($json['currencies']) && is_array($json['currencies'])) return $json['currencies'];
    }
    return array('USD','CAD','EUR','KYD','AED','ARS','AUD','AZN','BGN','BRL','BYN','CHF','CLP','CNY','COP','CUC','CZK','DKK','GBP','GEL','GIP','HKD','HRK','HUF','IDR','ILS','INR','IRR','IRT','ISK','JPY','KES','KRW','LAK','MKD','MUR','MXN','MYR','NGN','NOK','NZD','PEN','PHP','PKR','PLN','RON','RUB','RWF','SEK','SGD','THB','TND','TRY','TWD','UAH','VND','XOF','ZAR');
}

function fsfpay_get_supported_cryptocurrencies() {
    $try = wp_remote_get('https://panel.fsfpay.com/api/cryptocurrencies', array('timeout'=>8));
    if (!is_wp_error($try)) {
        $json = json_decode(wp_remote_retrieve_body($try), true);
        if ($json && isset($json['cryptocurrencies']) && is_array($json['cryptocurrencies'])) return $json['cryptocurrencies'];
    }
    return array('BTC','DOGE','ETH','LTC','TRX');
}

add_action('init','fsfpay_handle_callbacks');
function fsfpay_handle_callbacks(){ if(isset($_GET['fsfpay_callback']) && $_GET['fsfpay_callback']=='1'){ $payload = !empty($_POST)?print_r($_POST,true):file_get_contents('php://input'); update_option('fsfpay_last_callback',$payload); header('HTTP/1.1 200 OK'); echo 'OK'; exit; } }
