<?php
if (!defined('ABSPATH')) exit;

add_action('wp_enqueue_scripts', function(){
    wp_enqueue_style('fsfpay-public-css', FSFPAY_PLUGIN_URL . 'assets/style.css');
    wp_enqueue_script('fsfpay-public-js', FSFPAY_PLUGIN_URL . 'assets/fsfpay-public5.js', array('jquery'), '1.2', true);
    wp_localize_script('fsfpay-public-js', 'fsfpay_vars', array('ajax_url'=>admin_url('admin-ajax.php'),'nonce'=>wp_create_nonce('fsfpay_public_nonce')));
});

add_shortcode('fsfpay', 'fsfpay_shortcode_handler');
function fsfpay_shortcode_handler($atts){
    $opts = get_option(FSFPAY_OPTION_KEY);
    $atts = shortcode_atts(array('amount'=>'','currency'=>$opts['currency']??'USD','description'=>'','button_text'=>'Pay Now','cryptocurrency'=>''), $atts, 'fsfpay');

    $coins = function_exists('fsfpay_get_supported_cryptocurrencies')?fsfpay_get_supported_cryptocurrencies():explode(',',$opts['coins'] ?? 'BTC,DOGE,ETH,LTC,TRX');
    $coins = array_unique(array_map('trim',$coins));
    $currencies = function_exists('fsfpay_get_supported_currencies')?fsfpay_get_supported_currencies():array($opts['currency'] ?? 'USD','USD','EUR');

    $uniq = 'fsfpay_'.substr(md5(rand()),0,8);
    ob_start(); ?>
    <div class="fsfpay-card" id="<?php echo esc_attr($uniq); ?>">
      <div class="fsfpay-header"><h3><?php echo esc_html($atts['description']?:'FSFPAY Payment'); ?></h3></div>
      <div class="fsfpay-body">
        <label>Email</label>
        <input type="email" class="fsfpay-email" placeholder="you@example.com" required>
        <div class="row" style="display:flex;gap:8px">
          <div style="flex:1">
            <label>Amount</label>
            <input type="number" class="fsfpay-amount" step="any" value="<?php echo esc_attr($atts['amount']); ?>" required>
          </div>
          <div style="width:140px">
            <label>Currency</label>
            <select class="fsfpay-currency"><?php foreach($currencies as $c){ ?><option value="<?php echo esc_attr($c); ?>" <?php selected($c,$atts['currency']); ?>><?php echo esc_html($c); ?></option><?php } ?></select>
          </div>
        </div>

        <div style="margin-top:12px">
          <div class="label">Choose Cryptocurrency</div>
          <div class="fsfpay-coinlist">
            <?php foreach($coins as $c){ $coin=trim($c); ?>
              <label class="coin" data-coin="<?php echo esc_attr($coin); ?>">
                <input type="radio" name="fsfpay_coin_<?php echo esc_attr($uniq); ?>" value="<?php echo esc_attr($coin); ?>" <?php echo ($coin==($atts['cryptocurrency']?:'BTC'))?'checked':''; ?>>
                <img src="https://panel.fsfpay.com/assets/img/coins/<?php echo esc_attr($coin); ?>.png" alt="<?php echo esc_attr($coin); ?>">
                <span><?php echo esc_html($coin); ?></span>
              </label>
            <?php } ?>
          </div>
        </div>

        <div style="margin-top:14px">
          <button class="fsfpay-submit"><?php echo esc_html($atts['button_text']); ?></button>
          <div class="fsfpay-status" style="display:none;margin-top:8px"></div>
        </div>

        <!-- widget container: FSFPAY script should render inside here -->
        <div class="fsfpay-widget-container" style="margin-top:16px"></div>
      </div>
    </div>
    <?php return ob_get_clean();
}

add_action('wp_ajax_nopriv_fsfpay_create_session','fsfpay_create_session');
add_action('wp_ajax_fsfpay_create_session','fsfpay_create_session');
function fsfpay_create_session(){
    check_ajax_referer('fsfpay_public_nonce','nonce');
    $email = sanitize_email($_POST['email'] ?? '');
    $amount = sanitize_text_field($_POST['amount'] ?? '');
    $currency = sanitize_text_field($_POST['currency'] ?? '');
    $cryptocurrency = sanitize_text_field($_POST['cryptocurrency'] ?? 'BTC');
    if(empty($email) || empty($amount)) wp_send_json_error(array('message'=>'Email and amount required.'));
    $orderId = 'WP'.time();
    $params = array('orderId'=>$orderId,'email'=>$email,'amount'=>$amount,'currency'=>$currency,'cryptocurrency'=>$cryptocurrency,'successRedirectUrl'=>home_url('/?fsfpay_success=1'));
    $resp = fsfpay_create_payment($params);
    if(isset($resp['success']) && $resp['success']){
        if(!empty($resp['scriptUrl'])) wp_send_json_success(array('scriptUrl'=>$resp['scriptUrl'],'orderId'=>$orderId));
        if(!empty($resp['payment_url'])) wp_send_json_success(array('payment_url'=>$resp['payment_url'],'orderId'=>$orderId));
        if(!empty($resp['data']['scriptUrl'])) wp_send_json_success(array('scriptUrl'=>$resp['data']['scriptUrl'],'orderId'=>$orderId));
        if(!empty($resp['data']['payment_url'])) wp_send_json_success(array('payment_url'=>$resp['data']['payment_url'],'orderId'=>$orderId));
        wp_send_json_error(array('message'=>'Payment created but no widget/payment URL returned.'));
    } else {
        $msg = $resp['message'] ?? 'Unknown error';
        wp_send_json_error(array('message'=>$msg));
    }
}
