# FSFPAY Laravel Module (Example)

This package provides a simple **FSFPAY payment module for Laravel**, featuring:
- An **iframe-based payment widget**
- **Multi-language support** (English + Turkish)
- Configuration via `.env` (`API_USERNAME`, `API_KEY`, `SECRET_KEY`)
- Example controller, routes, and views

---

## 🧩 Installation

1. Copy this module into your Laravel project root  
   *(or install it as a local Composer package if you prefer).*

2. Add the following environment variables to your `.env` file:

   ```env
   FSFPAY_API_USERNAME=your_username
   FSFPAY_API_KEY=your_api_key
   FSFPAY_SECRET_KEY=your_secret_key
   FSFPAY_IFRAME_URL=https://panel.fsfpay.com/pay/iframe
   ```

3. Include the example routes from `routes/web.php` in your project routes.

4. Copy the view file:
   ```
   resources/views/payments/iframe.blade.php
   ```

5. Copy the translation files into your language folders:
   ```
   resources/lang/en/payment.php
   resources/lang/tr/payment.php
   ```

---

## ⚙️ Usage

- Visit `/fsfpay/checkout` to display the payment form.
- The form posts to `/fsfpay/create`, which builds the request payload and returns the iframe URL.
- The iframe loads the FSFPAY widget where the user completes the payment.

---

## 🌐 Multi-Language Support

Laravel’s locale system (`app()->setLocale()`) automatically controls which language file is used.

You can pass a `lang` field in your form (`en`, `tr`, etc.) —  
the controller defaults to the current application locale.

---

## 🔒 Security Notes

- **Do not** expose your API credentials or private keys in frontend code.
- Always send sensitive data (like API keys) only from your server backend.
- Add **callback verification** for FSFPAY webhooks (HMAC or IP validation).
- This module is an **example** for demonstration purposes only.  
  Make sure to implement production-level error handling, validation, and logging.

---

## 📄 License
MIT License — free to modify and integrate.
