// Minimal widget script to submit form and show iframe
document.addEventListener('DOMContentLoaded', function(){
  const form = document.getElementById('fsfpay-form');
  form.addEventListener('submit', async function(e){
    e.preventDefault();
    const data = new FormData(form);
    const body = {};
    data.forEach((v,k)=>body[k]=v);
    const res = await fetch('/fsfpay/create', {
      method: 'POST',
      headers: {'Content-Type':'application/json', 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]') ? document.querySelector('meta[name="csrf-token"]').getAttribute('content') : ''},
      body: JSON.stringify(body)
    });
    if (!res.ok){ alert('{{TRANSLATED_ERROR}}'); return; }
    const json = await res.json();
    const wrap = document.getElementById('fsfpay-iframe-wrap');
    const iframe = document.getElementById('fsfpay-iframe');
    iframe.src = json.iframe_src;
    wrap.style.display = 'block';
    window.scrollTo(0, document.body.scrollHeight);
  });
});
