<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>{{ __('payment.title') }}</title>
  <script src="/fsfpay-widget.js" defer></script>
  <style>
    body { font-family: Arial, sans-serif; padding: 20px; direction: {{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}; }
    .card { max-width: 640px; margin: 0 auto; padding: 20px; border: 1px solid #eee; border-radius: 8px; }
    label { display:block; margin-top:10px; }
    input, select, button { padding:8px; width:100%; box-sizing:border-box; }
  </style>
</head>
<body>
  <div class="card">
    <h2>{{ __('payment.header') }}</h2>
    <form id="fsfpay-form">
      <label>{{ __('payment.amount') }}
        <input type="number" name="amount" step="0.01" value="10.00" required>
      </label>
      <label>{{ __('payment.name') }}
        <input type="text" name="name" value="{{ old('name','Test User') }}" required>
      </label>
      <label>{{ __('payment.email') }}
        <input type="email" name="email" value="{{ old('email','test@example.com') }}" required>
      </label>
      <label>{{ __('payment.language') }}
        <select name="lang">
          <option value="en" {{ app()->getLocale()==='en' ? 'selected' : '' }}>English</option>
          <option value="es" {{ app()->getLocale()==='es' ? 'selected' : '' }}>Español</option>
          <option value="ar" {{ app()->getLocale()==='ar' ? 'selected' : '' }}>العربية</option>
        </select>
      </label>
      <button type="submit">{{ __('payment.pay') }}</button>
    </form>

    <div id="fsfpay-iframe-wrap" style="margin-top:20px; display:none;">
      <iframe id="fsfpay-iframe" src="" style="width:100%; height:600px; border:1px solid #ccc;" title="FSFPAY"></iframe>
    </div>
  </div>
</body>
</html>
