# FSFPAY Laravel Multi-Language Module

## What is inside
- Controller: app/Http/Controllers/FsfpayController.php
- Views: resources/views/fsfpay/iframe.blade.php
- Routes: routes/web.php
- Lang: resources/lang/en/fsfpay.php and resources/lang/tr/fsfpay.php
- .env.example
- composer.json

## Installation
1. Copy files into your Laravel project root preserving paths.
2. Add the route file contents to your `routes/web.php` or include the file.
3. Set credentials in your `.env` file:
   ```
   FSFPAY_API_KEY=...
   FSFPAY_API_USERNAME=...
   FSFPAY_SECRET_KEY=...
   ```
4. Point FSFPAY panel callback URL to:
   `https://yourdomain.com/fsfpay/callback`

## Notes
- The module uses Laravel's Http client (Illuminate\Support\Facades\Http). Make sure `laravel/framework` version includes it (Laravel 7+).
- Update the TODO area in callback() to match your order system.
- Language selection uses Laravel's locale (app()->getLocale()).

## Quick test
- Visit `/fsfpay/iframe?amount=1.23&currency=USD&email=test@example.com` to see the iframe starter page.
