<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>FSFPAY Payment</title>
</head>
<body>
    <h3>{{ __('fsfpay.pay_now') }}</h3>
    <p>Order: {{ $orderId }}</p>
    <p>Amount: {{ $amount }} {{ $currency }}</p>

    <form id="fsfpayForm" method="post" action="/fsfpay/create">
        @csrf
        <input type="hidden" name="orderId" value="{{ $orderId }}">
        <input type="hidden" name="amount" value="{{ $amount }}">
        <input type="hidden" name="currency" value="{{ $currency }}">
        <input type="hidden" name="email" value="{{ $email }}">
        <input type="hidden" name="cryptocurrency" value="BTC">
        <input type="hidden" name="callbackUrl" value="{{ url('/fsfpay/callback') }}">
        <button type="submit">{{ __('fsfpay.open_payment') }}</button>
    </form>

    <script>
    (function(){
        var form = document.getElementById('fsfpayForm');
        form.addEventListener('submit', function(e){
            e.preventDefault();
            var data = new FormData(form);
            fetch(form.action, { method: 'POST', body: data, credentials: 'same-origin' })
              .then(r=>r.json())
              .then(json=>{
                if (json && json.success && json.data && json.data.paymentUrl) {
                    // if FSFPAY returns paymentUrl or iframeUrl
                    window.location = json.data.paymentUrl;
                } else if (json && json.iframe) {
                    // render iframe
                    var iframe = document.createElement('iframe');
                    iframe.src = json.iframe;
                    iframe.width = '100%';
                    iframe.height = '600';
                    document.body.appendChild(iframe);
                } else {
                    alert('Payment initiation failed');
                }
              }).catch(err=>alert('Request error'));
        });
    })();
    </script>
</body>
</html>
