<?php
class ControllerExtensionPaymentFsfpayCommon {
    protected $error = array();

    public function index_common($route_base, $user_token_field = 'user_token') {
        $this->load->language($route_base . '/fsfpay');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        $token = isset($this->session->data[$user_token_field]) ? $this->session->data[$user_token_field] : '';

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            // Validate custom endpoint if provided: must start with https://
            if (!empty($this->request->post['payment_fsfpay_api_endpoint'])) {
                $ep = trim($this->request->post['payment_fsfpay_api_endpoint']);
                if (stripos($ep, 'https://') !== 0) {
                    $this->error['warning'] = $this->language->get('error_invalid_endpoint');
                }
            }

            if (!$this->error) {
                $this->model_setting_setting->editSetting('payment_fsfpay', $this->request->post);
                $this->session->data['success'] = $this->language->get('text_success');

                $this->response->redirect($this->url->link('marketplace/extension', $user_token_field.'='.$token.'&type=payment', true));
            }
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $keys = array(
            'payment_fsfpay_status','payment_fsfpay_sort_order','payment_fsfpay_title','payment_fsfpay_description',
            'payment_fsfpay_api_key','payment_fsfpay_api_secret','payment_fsfpay_test_mode','payment_fsfpay_test_endpoint','payment_fsfpay_live_endpoint',
            'payment_fsfpay_api_endpoint','payment_fsfpay_complete_status_id','payment_fsfpay_failed_status_id'
        );
        $settings = $this->model_setting_setting->getSetting('payment_fsfpay');

        foreach ($keys as $k) {
            if (isset($this->request->post[$k])) {
                $data[$k] = $this->request->post[$k];
            } elseif (isset($settings[$k])) {
                $data[$k] = $settings[$k];
            } else {
                $data[$k] = '';
            }
        }

        # Provide default endpoints if not set
        if (!$data['payment_fsfpay_test_endpoint']) {
            $data['payment_fsfpay_test_endpoint'] = 'https://panel.fsfpay.com/api/sandbox/checkout';
        }
        if (!$data['payment_fsfpay_live_endpoint']) {
            $data['payment_fsfpay_live_endpoint'] = 'https://panel.fsfpay.com/api/checkout';
        }
        if (!isset($data['payment_fsfpay_api_endpoint'])) {
            $data['payment_fsfpay_api_endpoint'] = ''; // optional custom endpoint
        }

        # Default recommendations (Processing = typical order_status_id variable in stores)
        if (!$data['payment_fsfpay_complete_status_id']) {
            $data['payment_fsfpay_complete_status_id'] = 2; // commonly 'Processing', may differ per store
        }

        $data['order_statuses'] = array();
        $this->load->model('localisation/order_status');
        $order_statuses = $this->model_localisation_order_status->getOrderStatuses();
        foreach ($order_statuses as $os) {
            $data['order_statuses'][] = $os;
        }

        $data['action'] = $this->url->link($route_base . '/fsfpay', $user_token_field.'='.$token, true);
        $data['cancel'] = $this->url->link('marketplace/extension', $user_token_field.'='.$token.'&type=payment', true);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view($route_base . '/fsfpay', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/fsfpay') && !$this->user->hasPermission('modify', 'payment/fsfpay')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }
}
