<?php
class ControllerExtensionPaymentFsfpayCommonCatalog {
    public function index_common($route_base='extension/payment', $catalog_path='extension/payment/fsfpay') {
        $this->load->language($route_base . '/fsfpay');
        $data['button_confirm'] = $this->language->get('button_confirm');
        $data['action'] = $this->url->link($catalog_path . '/checkout', '', true);
        return $this->load->view($route_base . '/fsfpay', $data);
    }

    public function checkout_common() {
        if (!isset($this->session->data['order_id'])) {
            $this->response->redirect($this->url->link('checkout/checkout', '', true));
            return;
        }

        $this->load->model('checkout/order');
        $order_id = (int)$this->session->data['order_id'];
        $order_info = $this->model_checkout_order->getOrder($order_id);

        if (!$order_info) {
            $this->response->redirect($this->url->link('checkout/checkout', '', true));
            return;
        }

        $api_key = $this->config->get('payment_fsfpay_api_key');
        $api_secret = $this->config->get('payment_fsfpay_api_secret');
        $test_mode = $this->config->get('payment_fsfpay_test_mode');
        $custom_endpoint = trim($this->config->get('payment_fsfpay_api_endpoint'));

        $endpoint = $custom_endpoint ? $custom_endpoint : ($test_mode ? $this->config->get('payment_fsfpay_test_endpoint') : $this->config->get('payment_fsfpay_live_endpoint'));

        if (!$endpoint) {
            $endpoint = $test_mode ? 'https://panel.fsfpay.com/api/sandbox/checkout' : 'https://panel.fsfpay.com/api/checkout';
        }

        $payload = array(
            'amount' => round($order_info['total'], 2),
            'currency' => $order_info['currency_code'],
            'order_id' => $order_id,
            'customer' => array(
                'email' => $order_info['email'],
                'name' => $order_info['firstname'] . ' ' . $order_info['lastname'],
            ),
            'return_url' => $this->url->link('checkout/success', '', true),
            'notify_url' => $this->url->link('extension/payment/fsfpay/webhook', '', true),
        );

        $json = json_encode($payload);

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => rtrim($endpoint, '/') . '/create-session',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Accept: application/json',
                'X-API-KEY: ' . $api_key,
                'X-API-SECRET: ' . $api_secret,
            ),
            CURLOPT_POSTFIELDS => $json,
            CURLOPT_TIMEOUT => 30,
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($err) {
            $this->log->write('FSFPAY create-session error: ' . $err);
            $this->session->data['error'] = 'Payment provider error. Please try another payment method.';
            $this->response->redirect($this->url->link('checkout/checkout', '', true));
            return;
        }

        $body = json_decode($response, true);
        if (empty($body) || empty($body['success']) || empty($body['checkout_url'])) {
            $this->log->write('FSFPAY invalid response: ' . $response);
            $this->session->data['error'] = 'Payment provider returned an unexpected response. Try again later.';
            $this->response->redirect($this->url->link('checkout/checkout', '', true));
            return;
        }

        $this->model_checkout_order->addHistory($order_id, $this->config->get('payment_fsfpay_order_status_id') ?: 1, 'Awaiting FSFPAY payment');
        $this->cart->clear();
        $this->response->redirect($body['checkout_url']);
    }

    public function webhook_common($post_route='extension/payment/fsfpay/webhook') {
        $body = file_get_contents('php://input');
        $data = json_decode($body, true);
        $this->load->model('checkout/order');

        if (empty($data) || empty($data['order_id'])) {
            http_response_code(400);
            echo json_encode(['error'=>'invalid payload']);
            return;
        }

        $order_id = (int)$data['order_id'];
        $order_info = $this->model_checkout_order->getOrder($order_id);
        if (!$order_info) {
            http_response_code(404);
            echo json_encode(['error'=>'order not found']);
            return;
        }

        if (!empty($data['signature'])) {
            $computed = hash_hmac('sha256', $body, $this->config->get('payment_fsfpay_api_secret'));
            if (!hash_equals($computed, $data['signature'])) {
                $this->log->write('FSFPAY IPN signature mismatch for order ' . $order_id);
                http_response_code(403);
                echo json_encode(['error'=>'signature mismatch']);
                return;
            }
        }

        $status = !empty($data['status']) ? $data['status'] : '';

        if (in_array($status, array('paid','completed'), true)) {
            $complete_status = $this->config->get('payment_fsfpay_complete_status_id') ?: $this->config->get('config_complete_status_id') ?: 5;
            $this->model_checkout_order->addHistory($order_id, $complete_status, 'FSFPAY payment completed via webhook.');
        } elseif (in_array($status, array('failed','cancelled','refused'), true)) {
            $failed_status = $this->config->get('payment_fsfpay_failed_status_id') ?: $this->config->get('config_order_status_id') ?: 10;
            $this->model_checkout_order->addHistory($order_id, $failed_status, 'FSFPAY reported payment failed/cancelled.');
        } else {
            $this->model_checkout_order->addHistory($order_id, $this->config->get('payment_fsfpay_order_status_id') ?: 1, 'FSFPAY webhook: status=' . $status);
        }

        header('Content-Type: application/json');
        echo json_encode(['success' => true]);
    }
}
