<?php
class FsfpayRedirectModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    public function postProcess()
    {
        $cart = $this->context->cart;
        if (!$cart || $cart->nbProducts() == 0) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        $api_key = Configuration::get('FSFPAY_API_KEY');
        $api_secret = Configuration::get('FSFPAY_API_SECRET');
        $test_mode = Configuration::get('FSFPAY_TEST_MODE');
        $custom = trim(Configuration::get('FSFPAY_CUSTOM_ENDPOINT'));
        $endpoint = $custom ? $custom : ($test_mode ? Configuration::get('FSFPAY_TEST_ENDPOINT') : Configuration::get('FSFPAY_LIVE_ENDPOINT'));
        if (!$endpoint) {
            $endpoint = $test_mode ? 'https://panel.fsfpay.com/api/sandbox/checkout' : 'https://panel.fsfpay.com/api/checkout';
        }

        $customer = $this->context->customer;
        $amount = number_format($this->context->cart->getOrderTotal(true, Cart::BOTH), 2, '.', '');

        $payload = array(
            'amount' => $amount,
            'currency' => $this->context->currency->iso_code,
            'order_id' => (int)$this->context->cart->id,
            'customer' => array(
                'email' => $customer->email,
                'name' => $customer->firstname . ' ' . $customer->lastname,
            ),
            'return_url' => $this->context->link->getPageLink('order-confirmation', true),
            'notify_url' => $this->context->link->getModuleLink('fsfpay', 'webhook', array(), true),
        );

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => rtrim($endpoint, '/') . '/create-session',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Accept: application/json',
                'X-API-KEY: ' . $api_key,
                'X-API-SECRET: ' . $api_secret,
            ),
            CURLOPT_POSTFIELDS => json_encode($payload),
            CURLOPT_TIMEOUT => 30,
        ));
        $response = curl_exec($ch);
        $err = curl_error($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($err) {
            PrestaShopLogger::addLog('FSFPAY create-session error: '.$err, 3, null, 'Cart', (int)$this->context->cart->id, true);
            Tools::redirect('index.php?controller=order&step=1&fsfpay_error=1');
        }

        $body = json_decode($response, true);
        if (empty($body) || empty($body['success']) || empty($body['checkout_url'])) {
            PrestaShopLogger::addLog('FSFPAY invalid response: '.$response, 3, null, 'Cart', (int)$this->context->cart->id, true);
            Tools::redirect('index.php?controller=order&step=1&fsfpay_error=1');
        }

        // Clear cart? Better leave until webhook confirms payment
        Tools::redirect($body['checkout_url']);
    }
}
?>
