<?php
class FsfpayWebhookModuleFrontController extends ModuleFrontController
{
    public $ssl = false;
    public $display_header = false;
    public $display_footer = false;

    public function postProcess()
    {
        $body = Tools::file_get_contents('php://input');
        $data = json_decode($body, true);
        PrestaShopLogger::addLog('FSFPAY webhook received: '.$body, 1, null, 'Module', null, true);

        if (empty($data) || empty($data['order_id'])) {
            header('Content-Type: application/json'); echo json_encode(array('error'=>'invalid payload')); http_response_code(400); exit;
        }

        $order_id = (int)$data['order_id'];
        $order = new Order($order_id);
        if (!Validate::isLoadedObject($order)) {
            header('Content-Type: application/json'); echo json_encode(array('error'=>'order not found')); http_response_code(404); exit;
        }

        // signature check
        if (!empty($data['signature'])) {
            $secret = Configuration::get('FSFPAY_API_SECRET');
            $computed = hash_hmac('sha256', $body, $secret);
            if (!hash_equals($computed, $data['signature'])) {
                PrestaShopLogger::addLog('FSFPAY signature mismatch for order '.$order_id, 3, null, 'Order', $order_id, true);
                header('Content-Type: application/json'); echo json_encode(array('error'=>'signature mismatch')); http_response_code(403); exit;
            }
        }

        $status = isset($data['status']) ? $data['status'] : '';
        if (in_array($status, array('paid','completed'), true)) {
            $new_state = (int)Configuration::get('FSFPAY_COMPLETE_STATUS');
            $order->setCurrentState($new_state);
            $order->save();
        } elseif (in_array($status, array('failed','cancelled','refused'), true)) {
            $new_state = (int)Configuration::get('FSFPAY_FAILED_STATUS');
            $order->setCurrentState($new_state);
            $order->save();
        } else {
            // add order message
            $history = new OrderHistory();
            $history->id_order = $order->id;
            $history->changeIdOrderState((int)Configuration::get('FSFPAY_COMPLETE_STATUS'), $order->id);
            $history->addWithemail(false);
        }

        header('Content-Type: application/json'); echo json_encode(array('success'=>true)); exit;
    }
}
?>
