<?php
if (!defined('_PS_VERSION_')) {
    exit;
}

class Fsfpay extends PaymentModule
{
    public function __construct()
    {
        $this->name = 'fsfpay';
        $this->tab = 'payments_gateways';
        $this->version = '1.0.0';
        $this->author = 'FSFPAY Integration';
        $this->need_instance = 0;
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => '8.9');
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('FSFPAY');
        $this->description = $this->l('FSFPAY hosted checkout gateway');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');
    }

    public function install()
    {
        if (!parent::install()
            || !$this->registerHook('payment')
            || !$this->registerHook('paymentReturn')
        ) {
            return false;
        }

        // add configuration defaults
        Configuration::updateValue('FSFPAY_API_KEY', '');
        Configuration::updateValue('FSFPAY_API_SECRET', '');
        Configuration::updateValue('FSFPAY_TEST_MODE', 1);
        Configuration::updateValue('FSFPAY_TEST_ENDPOINT', 'https://panel.fsfpay.com/api/sandbox/checkout');
        Configuration::updateValue('FSFPAY_LIVE_ENDPOINT', 'https://panel.fsfpay.com/api/checkout');
        Configuration::updateValue('FSFPAY_CUSTOM_ENDPOINT', '');
        Configuration::updateValue('FSFPAY_COMPLETE_STATUS', (int)Configuration::get('PS_OS_PAYMENT'));
        Configuration::updateValue('FSFPAY_FAILED_STATUS', (int)Configuration::get('PS_OS_CANCELED'));

        return true;
    }

    public function uninstall()
    {
        Configuration::deleteByName('FSFPAY_API_KEY');
        Configuration::deleteByName('FSFPAY_API_SECRET');
        Configuration::deleteByName('FSFPAY_TEST_MODE');
        Configuration::deleteByName('FSFPAY_TEST_ENDPOINT');
        Configuration::deleteByName('FSFPAY_LIVE_ENDPOINT');
        Configuration::deleteByName('FSFPAY_CUSTOM_ENDPOINT');
        Configuration::deleteByName('FSFPAY_COMPLETE_STATUS');
        Configuration::deleteByName('FSFPAY_FAILED_STATUS');
        return parent::uninstall();
    }

    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submit_fsfpay')) {
            $api_key = Tools::getValue('FSFPAY_API_KEY');
            $api_secret = Tools::getValue('FSFPAY_API_SECRET');
            $test_mode = Tools::getValue('FSFPAY_TEST_MODE');
            $test_ep = Tools::getValue('FSFPAY_TEST_ENDPOINT');
            $live_ep = Tools::getValue('FSFPAY_LIVE_ENDPOINT');
            $custom = Tools::getValue('FSFPAY_CUSTOM_ENDPOINT');
            $complete = (int)Tools::getValue('FSFPAY_COMPLETE_STATUS');
            $failed = (int)Tools::getValue('FSFPAY_FAILED_STATUS');

            // validate custom endpoint if provided
            if ($custom && stripos($custom, 'https://') !== 0) {
                $output .= $this->displayError($this->l('Invalid custom endpoint URL — must start with https://'));
            } else {
                Configuration::updateValue('FSFPAY_API_KEY', $api_key);
                Configuration::updateValue('FSFPAY_API_SECRET', $api_secret);
                Configuration::updateValue('FSFPAY_TEST_MODE', $test_mode ? 1 : 0);
                Configuration::updateValue('FSFPAY_TEST_ENDPOINT', $test_ep);
                Configuration::updateValue('FSFPAY_LIVE_ENDPOINT', $live_ep);
                Configuration::updateValue('FSFPAY_CUSTOM_ENDPOINT', $custom);
                Configuration::updateValue('FSFPAY_COMPLETE_STATUS', $complete);
                Configuration::updateValue('FSFPAY_FAILED_STATUS', $failed);
                $output .= $this->displayConfirmation($this->l('Settings updated'));
            }
        }

        $this->context->controller->addCSS($this->_path.'views/css/admin.css');

        $fields_form = array();
        $fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('FSFPAY Settings'),
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->l('API Key'),
                    'name' => 'FSFPAY_API_KEY',
                ),
                array(
                    'type' => 'password',
                    'label' => $this->l('API Secret'),
                    'name' => 'FSFPAY_API_SECRET',
                ),
                array(
                    'type' => 'switch',
                    'label' => $this->l('Test Mode'),
                    'name' => 'FSFPAY_TEST_MODE',
                    'values' => array(
                        array('id' => 'active_on', 'value' => 1, 'label' => $this->l('Yes')),
                        array('id' => 'active_off', 'value' => 0, 'label' => $this->l('No')),
                    ),
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Test Endpoint'),
                    'name' => 'FSFPAY_TEST_ENDPOINT',
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Live Endpoint'),
                    'name' => 'FSFPAY_LIVE_ENDPOINT',
                ),
                array(
                    'type' => 'text',
                    'label' => $this->l('Custom API Endpoint (optional)'),
                    'name' => 'FSFPAY_CUSTOM_ENDPOINT',
                    'desc' => $this->l('If empty default endpoint will be used. Must start with https:// if provided.'),
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Complete Order Status'),
                    'name' => 'FSFPAY_COMPLETE_STATUS',
                    'options' => array(
                        'query' => OrderState::getOrderStates((int)$this->context->language->id),
                        'id' => 'id_order_state',
                        'name' => 'name'
                    )
                ),
                array(
                    'type' => 'select',
                    'label' => $this->l('Failed Order Status'),
                    'name' => 'FSFPAY_FAILED_STATUS',
                    'options' => array(
                        'query' => OrderState::getOrderStates((int)$this->context->language->id),
                        'id' => 'id_order_state',
                        'name' => 'name'
                    )
                ),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right'
            )
        );

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

        foreach ($fields_form[0]['form']['input'] as $input) {
            $helper->fields_value[$input['name']] = Configuration::get($input['name']);
        }

        $helper->fields_value['FSFPAY_API_KEY'] = Configuration::get('FSFPAY_API_KEY');
        $helper->fields_value['FSFPAY_API_SECRET'] = Configuration::get('FSFPAY_API_SECRET');
        $helper->fields_value['FSFPAY_TEST_MODE'] = Configuration::get('FSFPAY_TEST_MODE');
        $helper->fields_value['FSFPAY_TEST_ENDPOINT'] = Configuration::get('FSFPAY_TEST_ENDPOINT');
        $helper->fields_value['FSFPAY_LIVE_ENDPOINT'] = Configuration::get('FSFPAY_LIVE_ENDPOINT');
        $helper->fields_value['FSFPAY_CUSTOM_ENDPOINT'] = Configuration::get('FSFPAY_CUSTOM_ENDPOINT');
        $helper->fields_value['FSFPAY_COMPLETE_STATUS'] = Configuration::get('FSFPAY_COMPLETE_STATUS');
        $helper->fields_value['FSFPAY_FAILED_STATUS'] = Configuration::get('FSFPAY_FAILED_STATUS');

        return $output.$helper->generateForm($fields_form);
    }

    // Hook for PrestaShop 1.6/1.7 (payment)
    public function hookPayment($params)
    {
        if (!$this->active) return;
        $this->context->smarty->assign(array(
            'fsfpay_button' => $this->l('Pay with FSFPAY'),
            'module_dir' => $this->_path,
            'action' => $this->context->link->getModuleLink($this->name, 'redirect', array(), true),
        ));

        if (version_compare(_PS_VERSION_, '1.7', '<')) {
            return $this->display(__FILE__, 'payment.tpl');
        } else {
            return $this->display(__FILE__, 'views/templates/hook/payment.tpl');
        }
    }

    public function hookPaymentReturn($params)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<')) {
            return $this->display(__FILE__, 'payment_return.tpl');
        } else {
            return $this->display(__FILE__, 'views/templates/hook/payment_return.tpl');
        }
    }
}
?>
