(function(){
    document.addEventListener('DOMContentLoaded', function(){
        var forms = document.querySelectorAll('.fsfpay-form');
        forms.forEach(function(form){
            form.addEventListener('submit', function(e){
                e.preventDefault();
                var amount = form.querySelector('input[name="amount"]').value;
                var currency = form.querySelector('input[name="currency"]').value;
                var description = form.querySelector('input[name="description"]').value;
                var btn = form.querySelector('.fsfpay-btn');
                btn.disabled = true;
                btn.textContent = 'Processing...';

                fetch(fsfpay_vars.rest_url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-WP-Nonce': fsfpay_vars.nonce
                    },
                    body: JSON.stringify({
                        amount: amount,
                        currency: currency,
                        description: description,
                    })
                }).then(function(resp){
                    return resp.json();
                }).then(function(data){
                    if (data.success && data.redirect) {
                        // redirect user to payment page
                        window.location.href = data.redirect;
                        return;
                    }
                    var msg = data.message || 'Payment request failed. See console for details.';
                    alert(msg);
                    console.error('FSFPAY response:', data);
                    btn.disabled = false;
                    btn.textContent = 'Pay with FSFPAY';
                }).catch(function(err){
                    console.error('FSFPAY fetch error:', err);
                    alert('Payment request failed. See console for details.');
                    btn.disabled = false;
                    btn.textContent = 'Pay with FSFPAY';
                });
            });
        });
    });
})();
