jQuery(document).ready(function ($) {
  async function sha256(str) {
    const buffer = new TextEncoder().encode(str);
    const hash = await crypto.subtle.digest("SHA-256", buffer);
    return Array.from(new Uint8Array(hash))
      .map(b => b.toString(16).padStart(2, "0"))
      .join("");
  }

  $('#fsfpay-open').on('click', async function () {
    const $btn = $(this);
    $btn.prop('disabled', true).text('Loading...');

    try {
      const hash = await sha256(fsfpayData.apiKey + fsfpayData.apiUsername + fsfpayData.secretKey);

      $.post(fsfpayData.baseUrl + 'api/cryptocurrencies', {
        apiKey: fsfpayData.apiKey,
        apiUsername: fsfpayData.apiUsername,
        requestHash: hash,
      })
        .done(function (res) {
          const data = typeof res === 'string' ? JSON.parse(res) : res;
          if (!data.success) {
            alert('Fsfpay Error: ' + data.message);
            $btn.prop('disabled', false).text('Choose Cryptocurrency');
            return;
          }

          let html = '<div id="fsfpay-widget" style="padding:1rem;">';
          $.each(data.cryptocurrencies, function (i, coin) {
            html += `<button class="coin-btn" data-coin="${coin.symbol}" 
                       style="margin:5px;padding:10px 15px;border:1px solid #ccc;cursor:pointer">
                      ${coin.name} (${coin.symbol})
                     </button>`;
          });
          html += '</div>';
          $('#fsfpay-container').html(html);
        })
        .fail(() => {
          alert('Fsfpay connection error');
          $btn.prop('disabled', false).text('Choose Cryptocurrency');
        });
    } catch (e) {
      console.error(e);
      alert('Hash error');
      $btn.prop('disabled', false).text('Choose Cryptocurrency');
    }
  });

  $(document).on('click', '.coin-btn', async function () {
    const coin = $(this).data('coin');
    const orderId = fsfpayData.orderId;

    const hash = await sha256(fsfpayData.apiKey + fsfpayData.apiUsername + fsfpayData.secretKey);

    $.post(fsfpayData.baseUrl + 'api/payment', {
      apiKey: fsfpayData.apiKey,
      apiUsername: fsfpayData.apiUsername,
      requestHash: hash,
      orderId: orderId,
      cryptocurrency: coin,
      callbackUrl: window.location.origin + '/?wc-api=fsfpay',
      successRedirectUrl: window.location.href,
      testmode: fsfpayData.testMode
    }).done(function (res) {
      const data = typeof res === 'string' ? JSON.parse(res) : res;
      if (data.success && data.scriptUrl) {
        $('#fsfpay-container').html(`<script src="${data.scriptUrl}"></script>`);
      } else {
        alert('Fsfpay Error: ' + (data.message || 'Unknown error'));
      }
    });
  });
});

