<?php isset($cryptocurrencies) or die(); ?>
<style>
.select-coin {
    border-radius:5px;
    border:2px solid #eee;
    background:#fff;
    padding:10px;
    display:flex;
    align-items:center;
    justify-content:space-between;
    cursor:pointer;
    transition:0.2s;
}
.select-coin:hover { border-color:#3057d5; }
.coin-label { width:calc(33.3% - 10px); display:inline-block; margin-top:10px; }
.coin-label input { display:none; }
.coin-label input:checked + .select-coin {
    border-color:#3057d5;
    background:#f0f4ff;
}
.coin-button {
    margin-top:20px;
    background:#3057d5;
    color:#fff;
    padding:10px 15px;
    border-radius:5px;
    border:none;
    cursor:pointer;
    font-size:16px;
}
.coin-list { display:flex; flex-wrap:wrap; gap:10px; }
</style>

<b><?php _e('Please select the cryptocurrency you want to use:', 'fsfpay-payment'); ?></b>

<form action="<?php echo esc_url( strtok($_SERVER["REQUEST_URI"], '?') ); ?>" method="get" id="fsfpay-coin-form">

    <?php foreach ($_GET as $key => $value) : ?>
        <?php if ($key !== 'coin') : ?>
            <input type="hidden" name="<?php echo esc_attr($key); ?>" value="<?php echo esc_attr($value); ?>">
        <?php endif; ?>
    <?php endforeach; ?>

    <div class="coin-list">
        <?php foreach ($cryptocurrencies as $coin => $name): ?>
            <label class="coin-label">
                <input type="radio" name="coin" value="<?php echo esc_attr($coin); ?>">
                <div class="select-coin">
                    <div>
                        <strong><?php echo esc_html($name); ?></strong> (<?php echo esc_html($coin); ?>)
                    </div>
                    <img src="<?php echo esc_url($gateway->base_url . 'assets/img/coins/' . $coin . '.png'); ?>" width="30" height="30" alt="<?php echo esc_attr($coin); ?>">
                </div>
            </label>
        <?php endforeach; ?>
    </div>
    <button type="submit" class="coin-button"><?php _e('Continue', 'fsfpay-payment'); ?></button>
</form>

<script>
// Coin seçildiğinde otomatik submit
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.coin-label input').forEach(function(input) {
        input.addEventListener('change', function() {
            document.getElementById('fsfpay-coin-form').submit();
        });
    });
});
</script>
