(function($){
  $(document).on('click', '.fsfpay-wp-button', function(e){
    e.preventDefault();
    var btn = $(this);
    var amount = btn.data('amount');
    var currency = btn.data('currency');
    var description = btn.data('description');
    var order = btn.data('order');

    var data = {
      action: 'fsfpay_create_session',
      nonce: fsfpay_wp.nonce,
      amount: amount,
      currency: currency,
      description: description,
      order_id: order
    };

    $.post(fsfpay_wp.ajax_url, data, function(resp){
      if (resp.success && resp.data.checkout_url) {
        window.location = resp.data.checkout_url;
      } else {
        alert('Payment error: ' + (resp.data && resp.data.message ? resp.data.message : 'unknown'));
        console.error(resp);
      }
    }).fail(function(xhr){
      alert('Payment request failed. See console for details.');
      console.error(xhr.responseText);
    });
  });
})(jQuery);
