<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  System.fsfpayvmfull
 * FSFPAY callback handler with VirtueMart best-effort integration.
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\Plugin;

class PlgSystemFsfpayvmfull extends Plugin
{
    public function onAfterInitialise()
    {
        $app = Factory::getApplication();
        if ($app->isClient('administrator')) {
            return;
        }
        $input = $app->input;
        $uri = $input->server->getString('REQUEST_URI', '');

        if (strpos($uri, '/fsfpay/callback') !== false || $input->getCmd('option') === 'com_fsfpay' || $input->getInt('fsfpay_callback', 0) === 1) {
            $this->handleCallback();
            $app->close();
        }
    }

    protected function handleCallback()
    {
        $app = Factory::getApplication();
        $input = $app->input;

        if ($input->getMethod() !== 'POST') {
            http_response_code(405);
            header('Allow: POST');
            echo 'Method not allowed';
            return;
        }

        $post = $input->post->getArray();
        if (empty($post['requestHash']) || empty($post['paymentStatus'])) {
            http_response_code(400);
            echo 'Bad request';
            return;
        }
        if ($post['paymentStatus'] !== 'successful') {
            echo 'Ignored';
            return;
        }

        $apiKey = $this->params->get('api_key', '');
        $apiUsername = $this->params->get('api_username', '');
        $secretKey = $this->params->get('secret_key', '');

        $calculated = hash('sha256', $apiKey . $apiUsername . $secretKey);
        if (!hash_equals($calculated, $post['requestHash'])) {
            http_response_code(403);
            echo 'Invalid hash';
            $this->log('Invalid hash: ' . json_encode($post));
            return;
        }

        $paymentId = $post['paymentId'] ?? '';
        $orderId = $post['orderId'] ?? '';
        $amount = $post['amount'] ?? '';
        $email = $post['email'] ?? '';
        $currency = $post['currency'] ?? '';

        // Try to update VirtueMart order by id / order_number / email
        try {
            $db = Factory::getDbo();
            $foundOrder = null;
            if (!empty($orderId)) {
                $q = $db->getQuery(true)
                    ->select('*')
                    ->from($db->quoteName('#__virtuemart_orders'))
                    ->where($db->quoteName('virtuemart_order_id') . ' = ' . $db->quote($orderId));
                $db->setQuery($q);
                $foundOrder = $db->loadObject();
                if (!$foundOrder) {
                    $q = $db->getQuery(true)
                        ->select('*')
                        ->from($db->quoteName('#__virtuemart_orders'))
                        ->where($db->quoteName('order_number') . ' = ' . $db->quote($orderId));
                    $db->setQuery($q);
                    $foundOrder = $db->loadObject();
                }
            }

            if (!$foundOrder && !empty($email)) {
                $q = $db->getQuery(true)
                    ->select('o.*')
                    ->from($db->quoteName('#__virtuemart_orders', 'o'))
                    ->join('INNER', $db->quoteName('#__virtuemart_order_userinfos', 'u') . ' ON u.order_id = o.virtuemart_order_id')
                    ->where($db->quoteName('u.email') . ' = ' . $db->quote($email));
                $db->setQuery($q);
                $foundOrder = $db->loadObject();
            }

            if (!$foundOrder) {
                $this->log('Order not found for orderId=' . $orderId . ' email=' . $email);
                echo 'OK - order not found';
                return;
            }

            $targetStatus = $this->params->get('paid_status', 'C');
            $q = $db->getQuery(true)
                ->update($db->quoteName('#__virtuemart_orders'))
                ->set($db->quoteName('order_status') . ' = ' . $db->quote($targetStatus))
                ->where($db->quoteName('virtuemart_order_id') . ' = ' . $db->quote($foundOrder->virtuemart_order_id));
            $db->setQuery($q);
            $db->execute();

            // insert history if possible
            try {
                $historyTable = '#__virtuemart_order_histories';
                $now = Factory::getDate()->toSql();
                $historyQuery = $db->getQuery(true)
                    ->insert($db->quoteName($historyTable))
                    ->columns([$db->quoteName('order_id'), $db->quoteName('order_status'), $db->quoteName('customer_notified'), $db->quoteName('comments'), $db->quoteName('created_on')])
                    ->values(implode(',', [$db->quote($foundOrder->virtuemart_order_id), $db->quote($targetStatus), 1, $db->quote('Payment received via FSFPAY (paymentId=' . $paymentId . ')'), $db->quote($now)]));
                $db->setQuery($historyQuery);
                $db->execute();
            } catch (\Throwable $e) {
                // ignore
            }

            $this->log('Order updated: ' . $foundOrder->virtuemart_order_id . ' pid=' . $paymentId);
            echo 'OK';
            return;
        } catch (\Throwable $e) {
            $this->log('DB error: ' . $e->getMessage());
            http_response_code(500);
            echo 'Error';
            return;
        }
    }

    protected function log($msg)
    {
        $logdir = JPATH_ROOT . '/tmp';
        if (!is_dir($logdir)) @mkdir($logdir, 0755, true);
        @file_put_contents($logdir . '/fsfpay_vm_full.log', '[' . date('Y-m-d H:i:s') . '] ' . $msg . PHP_EOL, FILE_APPEND | LOCK_EX);
    }
}
?>