<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  vmpayment.fsfpay
 * @copyright   FSFPAY Integration
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 *
 * VirtueMart payment plugin (basic). Handles payment initiation: creates a payment session on FSFPAY (via configurable API endpoint)
 * and redirects customer to the hosted payment page. Pairs with a system plugin that handles callbacks.
 *
 * Note: This is a general-purpose starter plugin. For production, adapt to your VirtueMart version and test thoroughly.
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class plgVmpaymentFsfpay
{
    protected $params = null;

    public function __construct(&$subject, $config = array())
    {
        // Load plugin params (works when Joomla loads plugin normally). If not available, fallback to direct JPlugin storage.
        $this->params = \JPluginHelper::getPlugin('vmpayment', 'fsfpay');
        if (is_object($this->params) && isset($this->params->params)) {
            $this->params = new \Joomla\Registry\Registry($this->params->params);
        } else {
            $this->params = new \Joomla\Registry\Registry();
        }
    }

    // Called by VirtueMart when order is confirmed (VM3/VM4 compatibility attempts)
    public function plgVmConfirmedOrder($cart, $order)
    {
        // Create a payment on FSFPAY via server-side POST to configured endpoint
        $apiEndpoint = $this->params->get('create_payment_endpoint', 'https://panel.fsfpay.com/api/create_payment');
        $apiKey = $this->params->get('api_key', '');
        $apiUsername = $this->params->get('api_username', '');
        $secretKey = $this->params->get('secret_key', '');

        $orderId = isset($order['details']['BT']->order_number) ? $order['details']['BT']->order_number : (isset($order['orderNumber']) ? $order['orderNumber'] : time());
        $amount = isset($order['details']['BT']->order_total) ? $order['details']['BT']->order_total : ($order['details']['BT']->order_subtotal ?? 0);
        $currency = $order['details']['BT']->currency_code_3 ?? ($order['details']['BT']->currency_id ?? 'TRY');
        $email = $order['details']['BT']->email ?? '';

        // Prepare payload - this depends on FSFPAY API; adjust keys as required
        $payload = array(
            'apiKey' => $apiKey,
            'apiUsername' => $apiUsername,
            'orderId' => $orderId,
            'amount' => $amount,
            'currency' => $currency,
            'email' => $email,
            // callback URL - use system plugin endpoint
            'callbackUrl' => rtrim(\JUri::root(), '/') . 'index.php?fsfpay_callback=1'
        );

        // Calculate requestHash same as callback expects (for some APIs)
        $payload['requestHash'] = hash('sha256', $apiKey . $apiUsername . $secretKey);

        // Server-side POST to API endpoint
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        $response = curl_exec($ch);
        $curlErr = curl_error($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Log call
        $logdir = JPATH_SITE . '/tmp';
        if (!is_dir($logdir)) @mkdir($logdir, 0755, true);
        @file_put_contents($logdir . '/fsfpay_initiate.log', '[' . date('Y-m-d H:i:s') . '] POST ' . $apiEndpoint . ' respCode=' . $httpCode . ' err=' . $curlErr . ' resp=' . $response . PHP_EOL, FILE_APPEND | LOCK_EX);

        // Expecting API to return an object with 'paymentUrl' or 'checkoutUrl' (adjust depending on FSFPAY)
        $paymentUrl = '';
        if ($response) {
            $decoded = json_decode($response, true);
            if (is_array($decoded) && !empty($decoded['paymentUrl'])) {
                $paymentUrl = $decoded['paymentUrl'];
            } elseif (is_array($decoded) && !empty($decoded['checkoutUrl'])) {
                $paymentUrl = $decoded['checkoutUrl'];
            }
        }

        if (empty($paymentUrl)) {
            // Fallback: try to post to panel.fsfpay.com/pay directly using an auto-submitting form
            $directUrl = $this->params->get('direct_payment_page', 'https://panel.fsfpay.com/pay');
            $html = '<form id="fsfpay_redirect" method="POST" action="' . htmlspecialchars($directUrl, ENT_QUOTES, "UTF-8") . '">';
            foreach ($payload as $k => $v) {
                $html .= '<input type="hidden" name="' . htmlspecialchars($k, ENT_QUOTES, "UTF-8") . '" value="' . htmlspecialchars($v, ENT_QUOTES, "UTF-8") . '" />';
            }
            $html .= '</form>';
            $html .= '<script>document.getElementById("fsfpay_redirect").submit();</script>';
            echo $html;
            exit;
        } else {
            // Redirect to paymentUrl returned by API
            header('Location: ' . $paymentUrl);
            exit;
        }
    }

    // Provide a simple name shown in VirtueMart list (optional)
    public function plgVmOnShowPaymentForm($cart, $msg = '')
    {
        $html = '<button type="button" onclick="window.location.href=window.location.href+\'&fsfpay_start=1\'">FSFPAY ile Öde</button>';
        echo $html;
    }
}
?>