(function(){
  async function createSession(endpoint, payload){
    try {
      const resp = await fetch(endpoint, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
      });
      return await resp.json();
    } catch (e) {
      console.error('FSFPAY createSession error', e);
      return { success:false, error: e.message || 'network error' };
    }
  }

  function init(selector){
    document.querySelectorAll(selector || '.fsfpay-button').forEach(function(btn){
      btn.addEventListener('click', async function(e){
        e.preventDefault();
        const amount = btn.getAttribute('data-amount') || '0.00';
        const currency = btn.getAttribute('data-currency') || 'USD';
        const order_id = btn.getAttribute('data-order') || Date.now().toString();
        const endpoint = btn.getAttribute('data-endpoint'); // your server endpoint
        if(!endpoint){
          alert('Payment endpoint not configured. Contact site admin.');
          return;
        }
        btn.disabled = true;
        btn.textContent = 'Processing...';
        const payload = {
          amount: amount,
          currency: currency,
          order_id: order_id,
          customer: { email: '', name: '' }, // optional: collect from form
          return_url: window.location.href,
          notify_url: endpoint.replace(/create_payment\.php$/, 'webhook.php')
        };
        const json = await createSession(endpoint, payload);
        btn.disabled = false;
        btn.textContent = 'Pay with FSFPAY';
        if(json && json.success && json.checkout_url){
          window.location.href = json.checkout_url;
        } else {
          alert('Payment error: ' + (json.error || 'Unknown'));
          console.error(json);
        }
      });
    });
  }

  // auto init on DOM ready
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', function(){ init(); });
  } else { init(); }

  window.FSFPAY_EMBED = { init: init };
})();