<?php
// create_payment.php - server-side endpoint to create FSFPAY hosted checkout session
// Usage: POST JSON { amount, currency, order_id, customer:{email,name}, return_url, notify_url }
// Response: JSON from FSFPAY (expects success and checkout_url)

$config = require __DIR__ . '/config.php';
$body = file_get_contents('php://input');
$data = json_decode($body, true);

if (!$data) {
    http_response_code(400);
    echo json_encode(['success'=>false,'error'=>'invalid payload']);
    exit;
}

$endpoint = !empty($config['test_mode']) ? $config['test_endpoint'] : $config['live_endpoint'];
$url = rtrim($endpoint, '/') . '/create-session';

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json',
    'X-API-KEY: ' . $config['api_key'],
    'X-API-SECRET: ' . $config['api_secret'],
]);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$response = curl_exec($ch);
$err = curl_error($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($err) {
    http_response_code(502);
    echo json_encode(['success'=>false,'error'=>'provider_error','details'=>$err]);
    exit;
}

$body = json_decode($response, true);
if (!$body || empty($body['success']) || empty($body['checkout_url'])) {
    http_response_code(502);
    echo json_encode(['success'=>false,'error'=>'invalid_provider_response','raw'=>$response]);
    exit;
}

// Return provider response to front-end
header('Content-Type: application/json');
echo json_encode($body);
