<?php
// webhook.php - receive FSFPAY webhooks
$config = require __DIR__ . '/config.php';
$body = file_get_contents('php://input');
$data = json_decode($body, true);
file_put_contents(__DIR__ . '/webhook.log', date('c') . ' - ' . $body . PHP_EOL, FILE_APPEND);

// Basic validation
if (empty($data) || empty($data['order_id'])) {
    http_response_code(400); echo json_encode(['error'=>'invalid payload']); exit;
}

// If signature present, verify HMAC SHA256
if (!empty($data['signature'])) {
    $computed = hash_hmac('sha256', $body, $config['api_secret']);
    if (!hash_equals($computed, $data['signature'])) {
        http_response_code(403); echo json_encode(['error'=>'signature mismatch']); exit;
    }
}

// Process status
$status = isset($data['status']) ? $data['status'] : '';
$order_id = $data['order_id'];
// TODO: update your DB / order record here based on $status (processing/completed/cancelled)

http_response_code(200); echo json_encode(['success'=>true]);
